/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.CustomSSLContext;
import com.tplink.eap.cloudsdk.client.IPacketDispatch;
import com.tplink.eap.cloudsdk.client.Packet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLClient {
    private SSLSocket sslSocket;
    private InetAddress address;
    private int port;
    private final int recvBufferLen = 32768;
    private byte[] recvBuffer = new byte[32768];
    private int recvLen = 0;

    public SSLClient() {
    }

    public SSLClient(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public void updateClient(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() throws IOException {
        SSLSocketFactory sslsocketfactory = CustomSSLContext.getSocketFactory();
        this.sslSocket = (SSLSocket)sslsocketfactory.createSocket(this.address, this.port);
    }

    public void send(byte[] message) throws IOException {
        this.sslSocket.getOutputStream().write(message);
        this.sslSocket.getOutputStream().flush();
    }

    public void recv(IPacketDispatch pktDispatch) throws IOException {
        int readLen;
        Packet packet = new Packet();
        while ((readLen = this.sslSocket.getInputStream().read(this.recvBuffer, this.recvLen, 32768 - this.recvLen)) > 0) {
            this.recvLen += readLen;
            if (this.recvLen < 4) continue;
            try {
                int pktLen = packet.unpack(this.recvBuffer, this.recvLen);
                pktDispatch.dispatch(packet);
                System.arraycopy(this.recvBuffer, pktLen, this.recvBuffer, 0, this.recvLen - pktLen);
                this.recvLen -= pktLen;
            }
            catch (Packet.UnmatchedMagicHeaderException e) {
                throw new IOException(e);
            }
            catch (Packet.UncompletePacketException e) {
            }
        }
        if (readLen == 0) {
            throw new Packet.InvalidMessageFormatException("Receive buffer is exhausted but still can't parse a complete packet.");
        }
        throw new SocketException("There is no more data because the end of the stream has been reached.");
    }

    public void close() throws IOException {
        try {
            if (this.sslSocket != null && !this.sslSocket.isClosed()) {
                this.sslSocket.close();
            }
        }
        finally {
            this.reset();
        }
    }

    public boolean isConnected() {
        if (this.sslSocket != null) {
            return this.sslSocket.isConnected();
        }
        return false;
    }

    private void reset() {
        this.recvLen = 0;
        this.port = 0;
        this.address = null;
    }
}

